USE [master]
GO

--- STAMM ---
PRINT 'Erzeuge Datenbank STAMM'
GO

DECLARE @SQLPath nvarchar(1024)
DECLARE @sqlStamm nvarchar(4000)

EXEC master.dbo.xp_instance_regread N'HKEY_LOCAL_MACHINE', N'Software\Microsoft\MSSQLServer\Setup', N'SQLPath', @SQLPath OUTPUT
SELECT @sqlStamm  = N'CREATE DATABASE [STAMM] ON  PRIMARY  ( NAME = N''STAMM'',  FILENAME = N''' + @SQLPath + '\Data\STAMM.mdf'',  SIZE = 51200KB , FILEGROWTH = 4096KB )  LOG ON ( NAME = N''STAMM_log'',  FILENAME = N''' + @SQLPath + '\Data\STAMM_log.ldf'',  SIZE = 25600KB , FILEGROWTH = 10%)'
EXEC (@sqlStamm)
GO

ALTER DATABASE [STAMM] SET  MULTI_USER
GO
ALTER DATABASE [STAMM] SET PAGE_VERIFY CHECKSUM
GO
ALTER DATABASE [STAMM] SET AUTO_CREATE_STATISTICS ON
GO
ALTER DATABASE [STAMM] SET AUTO_UPDATE_STATISTICS ON
GO
ALTER DATABASE [STAMM] SET  READ_WRITE
GO


--- PLHIMI ---
PRINT 'Erzeuge Datenbank PLHIMI'
GO

DECLARE @SQLPath nvarchar(1024)
DECLARE @sqlPLHIMI nvarchar(4000)

EXEC master.dbo.xp_instance_regread N'HKEY_LOCAL_MACHINE', N'Software\Microsoft\MSSQLServer\Setup', N'SQLPath', @SQLPath OUTPUT
SELECT @sqlPLHIMI = N'CREATE DATABASE [PLHIMI] ON  PRIMARY ( NAME = N''PLHIMI'', FILENAME = N''' + @SQLPath + '\Data\PLHIMI.mdf'', SIZE = 51200KB , FILEGROWTH = 4096KB )  LOG ON ( NAME = N''PLHIMI_log'', FILENAME = N''' + @SQLPath + '\Data\PLHIMI_log.ldf'', SIZE = 25600KB , FILEGROWTH = 10%)'
EXEC (@sqlPLHIMI)
GO

ALTER DATABASE [PLHIMI] SET MULTI_USER
GO
ALTER DATABASE [PLHIMI] SET PAGE_VERIFY CHECKSUM
GO
ALTER DATABASE [PLHIMI] SET AUTO_CREATE_STATISTICS ON
GO
ALTER DATABASE [PLHIMI] SET AUTO_UPDATE_STATISTICS ON
GO
ALTER DATABASE [PLHIMI] SET READ_WRITE
GO


--- TmpDB ---
PRINT 'Erzeuge Datenbank TmpDB'
GO

DECLARE @SQLPath nvarchar(1024)
DECLARE @sqlTmpDB nvarchar(4000)

EXEC master.dbo.xp_instance_regread N'HKEY_LOCAL_MACHINE', N'Software\Microsoft\MSSQLServer\Setup', N'SQLPath', @SQLPath OUTPUT
SELECT @sqlTmpDB  = N'CREATE DATABASE [TmpDB] ON  PRIMARY  ( NAME = N''TmpDB'',  FILENAME = N''' + @SQLPath + '\Data\TmpDB.mdf'',  SIZE = 51200KB , FILEGROWTH = 4096KB )  LOG ON ( NAME = N''TmpDB_log'',  FILENAME = N''' + @SQLPath + '\Data\TmpDB_log.ldf'',  SIZE = 25600KB , FILEGROWTH = 10%)'
EXEC (@sqlTmpDB)
GO

ALTER DATABASE [TmpDB] SET MULTI_USER
GO
ALTER DATABASE [TmpDB] SET PAGE_VERIFY CHECKSUM
GO
ALTER DATABASE [TmpDB] SET AUTO_CREATE_STATISTICS ON
GO
ALTER DATABASE [TmpDB] SET AUTO_UPDATE_STATISTICS ON
GO
ALTER DATABASE [TmpDB] SET READ_WRITE
GO



PRINT 'Merken des DataStorePath'
GO
USE STAMM
GO
CREATE TABLE CurrentDataStorePath
(
    DataStorePath  varchar(512)
  , AngelegtAm     DateTime
)
GO

DECLARE @SQLPath nvarchar(1024)
EXEC master.dbo.xp_instance_regread N'HKEY_LOCAL_MACHINE', N'Software\Microsoft\MSSQLServer\Setup', N'SQLPath', @SQLPath OUTPUT
INSERT INTO CurrentDataStorePath VALUES ( @SQLPath + '\Data\', getDate())
GO
